﻿/*
VERSION:		1.4

USAGE:
	#include "writeXml.as"
	myXml = new XML();
	writeXml( myData, myXml );
	
NOTE:
	Everything is stored inside a <data> tag.
*/

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// XML Writing function
writeXml = function( targetObject, targetXml, rootName )
{
	// Resolve optional parameters
	var rootName = (rootName) ? rootName : "data";
	
	// Manually create an "object" type of node in the xml, to store loose variables
	var xmlParentPath:XMLNode = targetXml;
	trace("object:   data:  create node");
	var newXmlTarget:XMLNode = addNode(rootName, xmlParentPath);
	addAttr( newXmlTarget, "xmlType", "object" );
	
	scanObject( targetObject, newXmlTarget );
}// writeXml()

scanObject = function( parentData, targetPath:XMLNode )
{
	trace("");
	trace("");
	trace("");
	trace("scanObject()");
	trace("sourceData:  "+parentData);
	trace("targetPath:  "+targetPath);
	trace("");
	
	
	
	// write attributes
	trace("- Writing attributes -");
	for (childName in parentData)
	{
		trace("childName:  "+childName);
		childPath = parentData[childName];
		trace("childPath:  "+childPath);
		
		var targetPath2:XMLNode = targetPath;		// XML target, can be altered if this is an array
		var childName2 = childName;						// variable name, can be altered if this is an array
		
		if ( typeof( childPath ) == "object")
		{
			//trace("childPath.length:  "+childPath.length);
			if (childPath.length == undefined)
			{
				// this is an object
				childType = "object"
			}else{
				// this is an array
				childType = "array";
			}
		}else{
			// this is a regular variable
			childType = "variable";
		}
		trace("childType:  "+childType);
		
		// write variables
		// // ignore all other types of data  (objects, arrays)
		if ( childType == "variable")
		{
			// store variable type
			// // bol
			if( typeof(childPath) == "boolean" ){
				childPath = "bol_"+String(childPath);
			}
			// // num
			else if( typeof(childPath) == "number" ){
				childPath = "num_"+String(childPath);
			}
			// // str
			else if( typeof(childPath) == "string" ){
				childPath = "str_"+String(childPath);
			}
			
			// if the name is a number, then create a node for this array element
			if ( isNaN( Number(childName)) == false )
			{
				trace(childName+" is a number.");
				// childName is a number, therefore it as an array element
				// add element node  &  set targetPath2 to this new node (for attribute-writing)
				delete targetPath2;
				var targetPath2:XMLNode = addNode( childName, targetPath );
				childName2 = "value";
				addAttr( targetPath2, "xmlType", "variable" );
			}
			// write the current variable as an attribute
			addAttr( targetPath2, childName2, childPath );
		}
	}
	trace("");
	
	
	
	// write nodes
	trace("- Writing nodes -");
	for (childName in parentData)
	{
		//
		trace("childName:  "+childName);
		childPath = parentData[childName];
		trace("childPath:  "+childPath);
		
		if ( typeof( childPath ) == "object")
		{
			//trace("childPath.length:  "+childPath.length);
			if (childPath.length == undefined)
			{
				// this is an object
				childType = "object"
			}else{
				// this is an array
				childType = "array";
			}
		}else{
			// this is a regular variable
			childType = "variable";
		}
		trace("childType:  "+childType);
		
		// write objects, arrays, variable elements
		// // ignore regular variables  (not array elements)
		if ( childType != "variable")
		{
			if ( childType == "object" )
			{
				var newNode:XMLNode = addNode( childName, targetPath );
				addAttr( newNode, "xmlType", "object" );
				scanObject( childPath, newNode );
			}
			
			if ( childType == "array" )
			{
				// create array node
				var newNode:XMLNode = addNode( childName, targetPath );
				addAttr( newNode, "xmlType", "array" );
				scanObject( childPath, newNode );
			}
		}
	}
	delete childName;
	delete childPath;
	delete childType;
}// scanObject()



addNode = function( newNodeName:String, xmlPath:XMLNode )
{
	trace("\tADDNODE()");
	trace("\t\tnewNodeName:  "+newNodeName);
	trace("\t\txmlPath:  "+xmlPath);
	var tempXml = new XML();
	var newNode:XMLNode = tempXml.createElement(newNodeName);
	delete tempXml;
	xmlPath.appendChild(newNode);
	var newXmlPath:XMLNode = xmlPath.lastChild;
	trace("\t\tReturn new node:   "+newXmlPath);

	return newXmlPath;
}// addNode()

addAttr = function( targetNode, newVariable, newValue )
{
	targetNode.attributes[newVariable] = newValue;
}// addAttr()
// END:	XML Writing function
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
